<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>SPO Product List</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; 
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; 
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; 
            margin: 10mm; 
        }
    </style>
</head>
<body>
    <h1>Vendor Product Analytics Report</h1>
    <h2>{{ $vendor->business_name }}</h2>
    <p>Generated on: {{ now()->format('d.m.Y') }}</p>

    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Category</th>
                <th>SKU</th>
                <th>Size/Variation</th>
                <th>Color</th>
                <th>Total Qty</th>
                <th>Remaining Qty</th>
               
                <th>Dimensions (LxWxH)</th>
                <th>Weight</th>
                <th>Volume</th>
                <th>Max Load</th>
                <th>Status</th>
                <th>Variant Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($products as $product)
                @if($product->variations->isEmpty())
                    <tr>
                        <td>{{ $product->id }}</td>
                        <td>{{ $product->name }}</td>
                        <td>{{ $product->category->name ?? '-' }}</td>
                        <td>{{ $product->sku ?? '-' }}</td>
                        <td>-</td>
                        <td>{{ $product->color->name ?? '-' }}</td>
                        <td>-</td>
                        <td>{{ $product->quantity ?? 0 }}</td>
                        <td>{{ $product->total_quantity ?? $product->quantity ?? 0 }}</td>
                        <td>{{ $product->length.'x'.$product->width.'x'.$product->height }}</td>
                        <td>{{ $product->weight }}</td>
                        <td>{{ $product->volume }}</td>
                        <td>{{ $product->max_load }}</td>
                        <td>{{ $product->status }}</td>
                        <td>-</td>
                    </tr>
                @else
                    @foreach($product->variations as $variation)
                        @foreach($variation->options as $option)
                            @php
                                $vendorQty = $option->vendorQuantities->firstWhere('vendor_id', $vendor->id);
                                $isDisabled = in_array($variation->id, $disabledVariants);
                            @endphp
                            <tr>
                                <td>{{ $product->id }}</td>
                                <td>{{ $product->name }}</td>
                                <td>{{ $product->category->name ?? '-' }}</td>
                                <td>{{ $option->sku }}</td>
                                <td>{{ $variation->size->name ?? $variation->variation->name ?? '-' }}</td>
                                <td>{{ $option->color->name ?? '-' }}</td>
                                <td>{{ $option->quantity ?? 0 }}</td>
                                <td>{{ $option->total_quantity ?? $option->quantity ?? 0 }}</td>
                                
                                <td>{{ $variation->length.'x'.$variation->width.'x'.$variation->height }}</td>
                                <td>{{ $variation->weight }}</td>
                                <td>{{ $variation->volume }}</td>
                                <td>{{ $variation->max_load }}</td>
                                <td>{{ $variation->status }}</td>
                                <td>{{ $isDisabled ? 'Disabled' : 'Enabled' }}</td>
                            </tr>
                        @endforeach
                    @endforeach
                @endif
            @endforeach
        </tbody>
    </table>
</body>
</html>